/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.api.handler.data.IDeal;
import noppes.npcs.api.handler.data.IMarcet;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.data.Deal;
import noppes.npcs.controllers.data.Lines;
import noppes.npcs.controllers.data.MarcetSection;
import noppes.npcs.controllers.data.MarkupData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleTrader;
import noppes.npcs.util.CustomNPCsScheduler;

public class Marcet
implements IMarcet,
Predicate<EntityNPCInterface> {
    public final Map<Integer, MarkupData> markup = new TreeMap<Integer, MarkupData>();
    public final Map<ItemStack, Integer> inventory = new HashMap<ItemStack, Integer>();
    public final Map<Integer, MarcetSection> sections = new TreeMap<Integer, MarcetSection>();
    private int id;
    public boolean isLimited;
    public boolean showXP;
    public long lastTime;
    public List<EntityPlayer> listeners = new ArrayList<EntityPlayer>();
    public String name;
    public long nextTime;
    public int updateTime;
    public Lines lines;
    public int limitedType;
    public long money;
    public double coefficient = 5.0;

    public Marcet(int id) {
        this.id = id;
        this.name = "Market";
        this.updateTime = 0;
        this.markup.put(0, new MarkupData(0, 0.0f, 0.0f, 1000));
        this.markup.put(1, new MarkupData(1, 0.0f, 0.0f, 2200));
        this.markup.put(2, new MarkupData(2, -0.0f, 0.0f, 5000));
        this.sections.put(0, new MarcetSection(0));
        this.lines = new Lines();
        this.isLimited = false;
        this.showXP = false;
        this.limitedType = 0;
        this.money = 0L;
        this.updateNew();
    }

    public void addInventoryItems(Map<ItemStack, Integer> items) {
        for (ItemStack stack : items.keySet()) {
            if (NoppesUtilServer.IsItemStackNull(stack)) continue;
            boolean added = false;
            ArrayList<ItemStack> del = new ArrayList<ItemStack>();
            for (ItemStack st : this.inventory.keySet()) {
                if (NoppesUtilServer.IsItemStackNull(st)) {
                    del.add(st);
                    continue;
                }
                if (!NoppesUtilPlayer.compareItems(stack, st, false, false)) continue;
                this.inventory.put(st, this.inventory.get(st) + items.get(stack));
                added = true;
                break;
            }
            for (ItemStack st : del) {
                this.inventory.remove(st);
            }
            if (added) continue;
            this.inventory.put(stack, items.get(stack));
        }
    }

    public void addListener(EntityPlayer listener, boolean isServer) {
        for (EntityPlayer pl : this.listeners) {
            if (listener != pl && !pl.equals((Object)listener)) continue;
            return;
        }
        this.listeners.add(listener);
        if (isServer && listener instanceof EntityPlayerMP) {
            this.sendTo((EntityPlayerMP)listener);
            this.detectAndSendChanges();
        }
    }

    public boolean apply(EntityNPCInterface npc) {
        if (npc == null || !(npc.advanced.roleInterface instanceof RoleTrader)) {
            return false;
        }
        return ((RoleTrader)npc.advanced.roleInterface).getMarket() == null ? ((RoleTrader)npc.advanced.roleInterface).getMarketID() == this.getId() : ((RoleTrader)npc.advanced.roleInterface).getMarket().getId() == this.getId();
    }

    public void closeForAllPlayers() {
        if (this.listeners == null) {
            return;
        }
        for (EntityPlayer player : this.listeners) {
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            CustomNPCsScheduler.runTack(() -> ((EntityPlayer)player).func_71053_j(), 250);
        }
    }

    public Marcet copy(int newID) {
        Marcet marcet = new Marcet(newID > -1 ? newID : this.id);
        marcet.readFromNBT(this.writeToNBT());
        marcet.updateNew();
        return marcet;
    }

    public void detectAndSendChanges() {
        for (EntityPlayer listener : this.listeners) {
            if (!(listener instanceof EntityPlayerMP)) continue;
            this.sendTo((EntityPlayerMP)listener);
        }
    }

    @Override
    public IDeal[] getAllDeals() {
        ArrayList<Deal> list = new ArrayList<Deal>();
        for (MarcetSection ms : this.sections.values()) {
            list.addAll(ms.deals);
        }
        return list.toArray(new IDeal[0]);
    }

    public Deal getDeal(int dealID) {
        for (MarcetSection ms : this.sections.values()) {
            for (Deal deal : ms.deals) {
                if (deal.getId() != dealID) continue;
                return deal;
            }
        }
        return null;
    }

    @Override
    public IDeal[] getDeals(int section) {
        if (!this.sections.containsKey(section)) {
            return new IDeal[0];
        }
        return this.sections.get((Object)Integer.valueOf((int)section)).deals.toArray(new IDeal[0]);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getSection(int dealID) {
        for (MarcetSection ms : this.sections.values()) {
            for (Deal deal : ms.deals) {
                if (deal.getId() != dealID) continue;
                return ms.getId();
            }
        }
        return -1;
    }

    public String getSettingName() {
        return "ID:" + this.id + " " + '\u00a7' + (this.isEmpty() ? "4" : "a") + this.getName();
    }

    public String getShowName() {
        return new TextComponentTranslation(this.name, new Object[0]).func_150254_d();
    }

    public boolean notHasListener(EntityPlayer player) {
        return !this.listeners.contains(player);
    }

    public boolean isEmpty() {
        return this.getAllDeals().length == 0;
    }

    @Override
    public boolean isLimited() {
        return this.isLimited;
    }

    public boolean isValid() {
        if (this.sections.isEmpty()) {
            return false;
        }
        boolean hasDeals = false;
        for (MarcetSection ms : this.sections.values()) {
            for (Deal deal : ms.deals) {
                if (deal.isValid()) {
                    hasDeals = true;
                    continue;
                }
                if (deal.getProduct().getMCItemStack() == null || deal.getProduct().getMCItemStack().func_77973_b() == Items.field_190931_a) {
                    return false;
                }
                if (deal.getMoney() != 0 || !deal.getCurrency().isEmpty()) continue;
                return false;
            }
        }
        return hasDeals;
    }

    public void readFromNBT(NBTTagCompound compound) {
        int i;
        this.id = compound.func_74762_e("MarcetID");
        this.name = compound.func_74779_i("Name");
        this.isLimited = compound.func_74767_n("IsLimited");
        this.showXP = compound.func_74767_n("ShowXP");
        this.money = compound.func_74763_f("Money");
        this.markup.clear();
        for (i = 0; i < compound.func_150295_c("Markup", 10).func_74745_c(); ++i) {
            MarkupData md = new MarkupData(compound.func_150295_c("Markup", 10).func_150305_b(i));
            this.markup.put(md.level, md);
        }
        if (this.markup.isEmpty()) {
            this.markup.put(0, new MarkupData(0, 0.15f, 0.8f, 1000));
            this.markup.put(1, new MarkupData(1, 0.0f, 0.45f, 2200));
            this.markup.put(2, new MarkupData(2, -0.05f, 0.0f, 5000));
        }
        this.inventory.clear();
        for (i = 0; i < compound.func_150295_c("Inventory", 10).func_74745_c(); ++i) {
            NBTTagCompound nbt = compound.func_150295_c("Inventory", 10).func_150305_b(i);
            this.inventory.put(new ItemStack(nbt), nbt.func_74762_e("TotalCount"));
        }
        this.sections.clear();
        TreeMap<Integer, MarcetSection> newSec = new TreeMap<Integer, MarcetSection>();
        if (!compound.func_150297_b("Sections", 9) || compound.func_150295_c("Sections", 10).func_74745_c() == 0) {
            newSec.put(0, new MarcetSection(0));
        } else {
            for (int i2 = 0; i2 < compound.func_150295_c("Sections", 10).func_74745_c(); ++i2) {
                NBTTagCompound nbt = compound.func_150295_c("Sections", 10).func_150305_b(i2);
                MarcetSection ms = MarcetSection.create(nbt);
                newSec.put(ms.getId(), MarcetSection.create(nbt));
            }
            TreeMap<Integer, MarcetSection> sec = new TreeMap<Integer, MarcetSection>();
            int i3 = 0;
            for (MarcetSection ms : newSec.values()) {
                sec.put(i3, ms);
                ++i3;
            }
            newSec = sec;
        }
        this.sections.putAll(newSec);
        this.limitedType = compound.func_74762_e("LimitedType");
        this.updateTime = compound.func_74762_e("UpdateTime");
        this.lastTime = compound.func_74763_f("LastTime");
        this.nextTime = compound.func_74763_f("NextTime");
        if (compound.func_150297_b("NpcLines", 10)) {
            this.lines.readNBT(compound.func_74775_l("NpcLines"));
        }
    }

    public void removeInventoryItems(Map<ItemStack, Integer> items) {
        for (ItemStack stack : items.keySet()) {
            if (NoppesUtilServer.IsItemStackNull(stack)) continue;
            ArrayList<ItemStack> del = new ArrayList<ItemStack>();
            for (ItemStack st : this.inventory.keySet()) {
                if (NoppesUtilServer.IsItemStackNull(st)) {
                    del.add(st);
                    continue;
                }
                if (!NoppesUtilPlayer.compareItems(stack, st, false, false)) continue;
                this.inventory.put(st, this.inventory.get(st) - items.get(stack));
                if (this.inventory.get(st) > 0) break;
                del.add(st);
                break;
            }
            for (ItemStack st : del) {
                this.inventory.remove(st);
            }
        }
    }

    public void removeListener(EntityPlayer player, boolean isServer) {
        for (EntityPlayer listener : this.listeners) {
            if (listener != player && !listener.equals((Object)player)) continue;
            if (isServer && listener instanceof EntityPlayerMP) {
                Server.sendData((EntityPlayerMP)listener, EnumPacketClient.MARCET_CLOSE, this.id);
            }
            this.listeners.remove(listener);
            this.detectAndSendChanges();
            return;
        }
    }

    public void sendTo(EntityPlayerMP player) {
        Server.sendData(player, EnumPacketClient.MARCET_DATA, 1, this.writeToNBT());
        Server.sendData(player, EnumPacketClient.MARCET_DATA, 2);
    }

    @Override
    public void setIsLimited(boolean limited) {
        if (this.isLimited == limited) {
            return;
        }
        this.isLimited = limited;
        if (limited) {
            this.updateNew();
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void update() {
        if ((long)this.updateTime < 5L) {
            return;
        }
        if (this.lastTime <= System.currentTimeMillis() - 0x6DDD00L || this.lastTime + (long)this.updateTime * 60000L < System.currentTimeMillis()) {
            this.updateNew();
        }
    }

    @Override
    public void updateNew() {
        this.inventory.clear();
        this.lastTime = System.currentTimeMillis();
        if (this.lines != null && !this.lines.isEmpty() && CustomNpcs.Server != null) {
            for (WorldServer world : CustomNpcs.Server.field_71305_c) {
                List npcs = world.func_175644_a(EntityNPCInterface.class, (Predicate)this);
                for (EntityNPCInterface npc : npcs) {
                    if (!npc.func_70089_S()) continue;
                    npc.saySurrounding(this.lines.getLine(true));
                }
            }
        }
        this.money = (long)(Math.random() * 7500.0);
        for (MarcetSection ms : this.sections.values()) {
            for (Deal deal : ms.deals) {
                deal.updateNew();
                this.money += (long)((double)deal.getMoney() * (this.coefficient + Math.random() * this.coefficient));
                for (IItemStack iStack : deal.getCurrency().getItems()) {
                    ItemStack stack = iStack.getMCItemStack();
                    if (NoppesUtilServer.IsItemStackNull(stack)) continue;
                    int count = (int)((double)stack.func_190916_E() * (this.coefficient + Math.random() * this.coefficient));
                    boolean added = false;
                    for (ItemStack st : this.inventory.keySet()) {
                        if (NoppesUtilServer.IsItemStackNull(st) || !NoppesUtilPlayer.compareItems(stack, st, false, false)) continue;
                        this.inventory.put(st, this.inventory.get(st) + count);
                        added = true;
                        break;
                    }
                    if (added) continue;
                    this.inventory.put(stack, count);
                }
            }
        }
        this.detectAndSendChanges();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateTime() {
        if (this.nextTime < 0L) {
            this.nextTime = 0L;
        } else if (this.nextTime > 0L) {
            this.nextTime -= 500L;
            if (this.nextTime < 0L) {
                this.nextTime = 0L;
            }
        }
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("MarcetID", this.id);
        compound.func_74778_a("Name", this.name);
        compound.func_74757_a("IsLimited", this.isLimited);
        compound.func_74757_a("ShowXP", this.showXP);
        compound.func_74772_a("Money", this.money);
        NBTTagList markup = new NBTTagList();
        for (int level : this.markup.keySet()) {
            MarkupData mp = this.markup.get(level);
            mp.level = level;
            markup.func_74742_a((NBTBase)mp.getNBT());
        }
        compound.func_74782_a("Markup", (NBTBase)markup);
        NBTTagList items = new NBTTagList();
        for (ItemStack stack : this.inventory.keySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            stack.func_77955_b(nbt);
            nbt.func_74768_a("TotalCount", this.inventory.get(stack).intValue());
            items.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("Inventory", (NBTBase)items);
        NBTTagList secs = new NBTTagList();
        for (MarcetSection ms : this.sections.values()) {
            secs.func_74742_a((NBTBase)ms.save());
        }
        compound.func_74782_a("Sections", (NBTBase)secs);
        compound.func_74768_a("LimitedType", this.limitedType);
        compound.func_74768_a("UpdateTime", this.updateTime);
        compound.func_74772_a("LastTime", this.lastTime);
        compound.func_74772_a("NextTime", this.lastTime + (long)this.updateTime * 60000L - System.currentTimeMillis());
        compound.func_74782_a("NpcLines", (NBTBase)this.lines.writeToNBT());
        return compound;
    }
}

